## This script will find the NewsGator email enabled lists, should they exist, and delete them
  
function find-SPList( [string]$WebAppUrl )
{
    #Get all Webs
    $webs = Get-SPWebApplication $WebAppUrl | Get-SPSite -Limit All | Get-SPWeb -Limit All
 
    #Iterate through webs
    foreach ($web in $webs)
    {
        foreach ($list in $web.Lists)
        {
            if($list.Title -eq "Social Emails")
            {
                Write-Host "Found the NewGator Email enabled list for Social Emails at " $web
                $list.Delete()
                Write-Host "Deleted NewGator Email enabled list for Social Emails at " $web
            }
            if($list.Title -eq "Social Email Questions")
            {
                Write-Host "Found the NewGator Email enabled list for Social Email Questions at " $web
                $list.Delete()
                Write-Host "Deleted NewGator Email enabled list for Social Email Questions at " $web
                
            }
            if($list.Title -eq "Social Email Microblogs")
            {
                Write-Host "Found the NewGator Email enabled list for Social Email microblogs at " $web
                $list.Delete()
                Write-Host "Deleted NewGator Email enabled list for Social Email Microblogs at " $web
                
            }
            if($list.Title -eq "Social Email Microblog")
            {
                Write-Host "Found the NewGator Email enabled list for Social Email microblogs at " $web
                $list.Delete()
                Write-Host "Deleted NewGator Email enabled list for Social Email Microblogs at " $web
               
            } 
        }
        $web.Dispose()
    }

}

function removeNGEmailLists ([string]$WebAppUrl){
find-SPList( $WebAppUrl );
}
