﻿#This script disables all site, site collection, and web application features.

Function disableNGFeatures($WebAppURL)
{

    # Get All Web Applications
    $WebApps=Get-SPWebApplication $WebAppURL
  
	    foreach($site in $webApps.Sites)
	    {
		    $modWebs = $site.AllWebs
		
		    foreach($modWeb in $modWebs)
		    {
			    foreach($feature in (Get-SPFeature -Web $modweb.Url | Where-Object {$_.DisplayName -like "*NewsGator*"}))
		        {
                        Write-Host "disabling " $feature.DisplayName " feature found at web " $modweb.Url
                        Disable-SPFeature -Identity $feature.id -Url $modWeb.Url -Force -Confirm:$false
                }
                $modWeb.Dispose()  
            }
            foreach($feature in (Get-SPFeature -Site $site.Url | Where-Object {$_.DisplayName -like "*NewsGator*"}))
		    {
                Write-Host "Disabling " $feature.DisplayName " feature found at site " $site.Url
                Disable-SPFeature -Identity $feature.id -Url $site.Url -Force -Confirm:$false 

            }
		$site.Dispose()
		}

    foreach($feature in (Get-SPFeature -WebApplication $webApp.Url | Where-Object {$_.DisplayName -like "*NewsGator*"}))
    {
        Write-Host "Disabling " $feature.DisplayName "feature found at web application " $webApp.Url
        Disable-SPFeature -Identity $feature.id -Url $webApp.Url -Force -Confirm:$false

    }
}
