#This script is used to remove newsgator service applications
function Get-ScriptDirectory
{
 $Invocation = (Get-Variable MyInvocation -Scope 1).Value
 Split-Path $Invocation.MyCommand.Path
}	

function VerifySolutionUninstall
{ 
	$counter = 1
	$maximum = 20
	$sleeptime = 5
   	while ($Solution.JobExists -and ( $counter -lt $maximum ) ) 
	{
    	Write-Host "Retracting $SolutionName.  Please wait..."
		sleep $sleeptime
		$counter++
	}
}
function removeNGServiceApps()
{

#Set Variables for Service app removal
$NGServiceApp = Get-SPServiceApplication | Where {$_.Name -eq "NewsGator Social Platform Services"}
$NGAppProxy = Get-SpServiceApplicationProxy | Where {$_.Name -eq "NewsGator Social Platform Services Proxy"}
$NewsServiceApp = Get-SPServiceApplication | Where {$_.Name -eq "NewsGator News Stream Services"}
$NewsProxy = Get-SPServiceApplicationProxy | Where {$_.Name -eq "NewsGator News Stream Services Proxy"}
$sleeptime = 15

#Remove NewsGator Core Service Application
Write-Host "Attempting to remove NewsGator Social Service Application...."
Sleep $sleeptime
	if($NGServiceApp -ne $null) 
	{
		$NGServiceApp | ForEach-Object {Remove-SPServiceApplication $_.Id -confirm:$false}
		Write-Host "NewsGator Social Service Application removed."
		Write-Host
		Sleep $sleeptime
	}	
	else
	{
		Write-Host "NewsGator Social Service Application already removed or does not exist."
		Write-Host
		Sleep $sleeptime
	}
#Remove NewsGator Core Service Application Proxy
Write-Host "Attempting to remove NewsGator Social Service Application Proxy...."
Sleep $sleeptime
	if($NGAppProxy -ne $null)
	{
		$NGAppProxy | ForEach-Object {Remove-SPServiceApplicationProxy $_.Id -confirm:$false}
		Write-Host "NewsGator Social Service Application Proxy removed."
		Sleep $sleeptime
	}
	else
	{
		Write-Host "NewsGator Social Service Application Proxy already removed or does not exist."
		Sleep $sleeptime
	}
	
#Remove NewsGator News Stream Service Application
Write-Host "Attempting to remove NewsGator News Stream Service Application...."
sleep $sleeptime
	if($NewsServiceApp -ne $null) 
	{
		$NewsServiceApp | ForEach-Object {Remove-SPServiceApplication $_.Id -confirm:$false}
		Write-Host "NewsGator News Stream Service Application removed."
		Write-Host
		Sleep $sleeptime
	}	
	else
	{
		Write-Host "NewsGator News Stream Service Application already removed or does not exist."
		Write-Host
		Sleep $sleeptime
	}
	
#Remove NewsGator News Stream Service Application Proxy
Write-Host "Attempting to remove NewsGator News Stream Service Application Proxy...."
Sleep $sleeptime
	if($NewsProxy -ne $null)
	{
		$NewsProxy | ForEach-Object {Remove-SPServiceApplicationProxy $_.Id -confirm:$false}
		Write-Host "NewsGator News Stream Service Application Proxy removed."
		Write-Host
		Sleep $sleeptime
	}
	else
	{
		Write-Host "NewsGator News Stream Service Application Proxy already removed or does not exist."
		Write-Host
		Sleep $sleeptime
	}
}
	