# This script is used to remove NewsGator Profile Properties

function removeNGProfileProperties([String]$MySite)
{
    $site = Get-SPSite $MySite
    $context = Get-SPServiceContext($site)
    $upcm = New-Object Microsoft.Office.Server.UserProfiles.UserProfileConfigManager($context)    
    $cm = $upcm.ConnectionManager                 
    $pdtc = $upcm.GetPropertyDataTypes()
    $ppm = $upcm.ProfilePropertyManager
    $cpm = $ppm.GetCoreProperties()
    $ptpm = $ppm.GetProfileTypeProperties([Microsoft.Office.Server.UserProfiles.ProfileType]::User)
    $psm = [Microsoft.Office.Server.UserProfiles.ProfileSubTypeManager]::Get($context)
    $ps = $psm.GetProfileSubtype([Microsoft.Office.Server.UserProfiles.ProfileSubtypeManager]::GetDefaultProfileName([Microsoft.Office.Server.UserProfiles.ProfileType]::User))
    $pspm = $ps.Properties
 
    # Remove User Profile Property by Name
    $property = $pspm.GetPropertyByName("NGDigestEmailVersion")             
    if($property -ne $null)
    {
        Write-Host -f Magenta "Deleting NGDigestEmailVersion property ............."
        $cpm.RemovePropertyByName("NGDigestEmailVersion")          
        Write-Host -f Green "NGDigestEmailVersion property is deleted successfully"
    }
    else
    {
         Write-Host -f Yellow "NGDigestEmailVersion property does not exists"
    }

    $property = $pspm.GetPropertyByName("NGAllowMetaEmail")             
    if($property -ne $null)
    {
        Write-Host -f Magenta "Deleting NGAllowMetaEmail property ............."
        $cpm.RemovePropertyByName("NGAllowMetaEmail")          
        Write-Host -f Green "NGAllowMetaEmail property is deleted successfully"
    }
    else
    {
         Write-Host -f Yellow "NGAllowMetaEmail property does not exists"
    }
    #NewsGatorProperties
    $property = $pspm.GetPropertyByName("NewsGatorProperties")             
    if($property -ne $null)
    {
        Write-Host -f Magenta "Deleting NewsGatorProperties property ............."
        $cpm.RemovePropertyByName("NewsGatorProperties")          
        Write-Host -f Green "NewsGatorProperties property is deleted successfully"
    }
    else
    {
         Write-Host -f Yellow "NewsGatorProperties property does not exists"
    }
}