SET NOCOUNT ON;

SELECT GETDATE();

-- Drop UPA_Mismatches table if it exists
IF EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[UPA_Mismatches]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
	DROP TABLE [dbo].[UPA_Mismatches]
END
GO

CREATE TABLE [dbo].[UPA_Mismatches]
(
	[OldRecordId] [bigint] NOT NULL,
	[NewRecordId] [bigint] NULL
) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX IX_UPA_Mismatches_NewRecordId
ON [dbo].[UPA_Mismatches] ([NewRecordId])
INCLUDE ([OldRecordId])

--============================================================================================
-- Change these to the correct database names in your environment.
--========================================================================================
DECLARE @SPUserProfileDB NVARCHAR(255) = 'Profile DB';
DECLARE @NGServicesDB NVARCHAR(255) = 'NewsGator_SocialServices';
DECLARE @NGReportingDB NVARCHAR(255) = 'NewsGator_Reporting';
--============================================================================================

DECLARE @Nothing NVARCHAR(255) = '';
DECLARE @sql nvarchar(4000);
DECLARE @Parms nvarchar(500);

DECLARE @More BIT = 1;
DECLARE @NewUserId bigint = 0;
DECLARE @OldUserId bigint = 0;
DECLARE @Count INT = 0;

--Users in Sitrion no longer in SharePoint
IF OBJECT_ID('tempdb..#NGDeleted') IS NOT NULL
    DROP TABLE #NGDeleted

CREATE TABLE #NGDeleted
(
	ID INT IDENTITY(1,1) PRIMARY KEY,
	NGRecordId BIGINT
)

SELECT @sql = 
'INSERT INTO #NGDeleted ' +
'	SELECT NGUP.RecordId ' +
'	FROM [' + @NGServicesDB + '].dbo.UserProfile AS NGUP ' +
'   LEFT JOIN [' + @SPUserProfileDB + '].dbo.UserProfile_Full AS SPUP ON SPUP.NTName = NGUP.AccountName' +
'	WHERE SPUP.RecordID IS NULL AND NGUP.RecordId > 0';
EXEC sp_executesql @sql

SET @More = 1;
SET @NewUserId = 0;
SET @OldUserId = 0;
SET @Count = 0;

SELECT @Count = COUNT(*)
FROM #NGDeleted;

PRINT 'Working ' + CAST(@Count AS VARCHAR(25)) + ' records in NewsGator User Profile no longer in SharePoint...'

DECLARE vendor_cursor CURSOR FOR 
	SELECT NGRecordId, NULL
	FROM #NGDeleted

OPEN vendor_cursor

FETCH NEXT FROM vendor_cursor INTO @OldUserId, @NewUserId

WHILE (@@FETCH_STATUS = 0)
BEGIN
	IF @NewUserId IS NULL
	BEGIN
		SELECT @sql = 
		'SELECT @NewUserIdOUT = MIN(RecordId) FROM [' + @NGServicesDB + '].dbo.UserProfile;'
		SET @Parms = N'@NewUserIdOUT BIGINT OUTPUT';
		EXEC sp_executesql @sql, @Parms, @NewUserIdOUT=@NewUserId OUTPUT;
		IF ISNULL(@NewUserId , 0) >= 0 SET @NewUserId = 0;
		SET @NewUserId = @NewUserId - 1;
	END

	SELECT @sql = 
	'EXEC [' + @NGServicesDB + '].dbo.UPA_MigrateUserFromTempUser @OldUserId=@OldUserId, @NewUserId=@NewUserId'
	SET @Parms = N'@OldUserId BIGINT, @NewUserId BIGINT';
	EXEC sp_executesql @sql, @Parms, @OldUserId, @NewUserId
		
	SELECT @sql = 
	'EXEC [' + @NGReportingDB + '].dbo.UPA_ReportingMigrateUserFromTempUser @OldUserId=@OldUserId, @NewUserId=@NewUserId'
	SET @Parms = N'@OldUserId BIGINT, @NewUserId BIGINT';
	EXEC sp_executesql @sql, @Parms, @OldUserId, @NewUserId

	SELECT @sql = 
	'EXEC [' + @NGServicesDB + '].dbo.UPA_MigrateUserProfile @OldUserId=@OldUserId, @NewUserId=@NewUserId, @IsDeleted=0'
	SET @Parms = N'@OldUserId BIGINT, @NewUserId BIGINT, @IsDeleted BIT';
	EXEC sp_executesql @sql, @Parms, @OldUserId, @NewUserId, 1

	SET @Count = @Count - 1;

	IF (@Count % 1000) = 0 PRINT CAST(@Count AS VARCHAR(25)) + ' records remaining to be migrated...'

	FETCH NEXT FROM vendor_cursor INTO @OldUserId, @NewUserId
END 
CLOSE vendor_cursor;
DEALLOCATE vendor_cursor;

DROP TABLE #NGDeleted

--Cycles
PRINT 'Detecting any cycles in user profiles...'

IF OBJECT_ID('tempdb..#Node') IS NOT NULL
    DROP TABLE #Node

CREATE TABLE #Node
(
	RecordId BIGINT PRIMARY KEY,
	AccountName NVARCHAR(255)
)

IF OBJECT_ID('tempdb..#Edge') IS NOT NULL
    DROP TABLE #Edge

CREATE TABLE #Edge
(
	ID INT IDENTITY(1,1) PRIMARY KEY,
	NGRecordId BIGINT,
	SPRecordId BIGINT,
	NGAccountName NVARCHAR(255),
	SPAccountName NVARCHAR(255) NULL
)

SELECT @sql = 
'INSERT INTO #Node ' +
'	SELECT RecordId, Accountname ' +
'	FROM [' + @NGServicesDB + '].dbo.UserProfile';
EXEC sp_executesql @sql
		
SELECT @sql = 
'INSERT INTO #Edge(NGRecordId, SPRecordId, NGAccountName, SPAccountName) ' +
'	SELECT NGUP.RecordId, SPUP.RecordID, NGUP.AccountName, SPUP.NTName ' +
'	FROM [' + @NGServicesDB + '].dbo.UserProfile AS NGUP ' +
'	LEFT JOIN [' + @SPUserProfileDB + '].dbo.UserProfile_Full AS SPUP ON NGUP.AccountName = SPUP.NTName ' +
'	WHERE NGUP.RecordId != SPUP.RecordID AND SPUP.RecordId IS NOT NULL';
EXEC sp_executesql @sql

IF OBJECT_ID('tempdb..#Graph') IS NOT NULL
    DROP TABLE #Graph

CREATE TABLE #Graph
(
	ID INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
	Seq INT,
	NGRecordId INT,
	EdgeID INT,
	SPRecordId INT,
	NodeIDRoot int,
	NGAccountName NVARCHAR(255),
	SPAccountName NVARCHAR(255) NULL,
	IsCycle BIT DEFAULT (0)
)

INSERT INTO #Graph (Seq, NGRecordId, NodeIDRoot, EdgeID, SPRecordId)
	SELECT DISTINCT 1, NGRecordId, NGRecordId, ID, SPRecordId
	FROM #Edge

DECLARE @Seq INT, @RC INT
SET @Seq = 1
SET @RC = 1

WHILE @RC > 0
BEGIN
	UPDATE #Graph
	SET	IsCycle = 1
	WHERE NodeIDRoot = SPRecordId
	AND	Seq = @Seq

	INSERT INTO #Graph (Seq, NGRecordId, NodeIDRoot, EdgeID, SPRecordId)
		SELECT DISTINCT @Seq + 1, #Edge.NGRecordId, #Graph.NodeIDRoot, 
			#Edge.ID, #Edge.SPRecordId
		FROM 	#Graph
		INNER JOIN #Edge ON #Graph.SPRecordId = #Edge.NGRecordId
		LEFT OUTER JOIN #Graph ex ON ex.NodeIDRoot = #Graph.NodeIDRoot 
			AND ex.EdgeID = #Edge.ID
		WHERE 	#Graph.IsCycle = 0
		AND 	#Graph.Seq = @Seq
		AND 	ex.ID IS NULL

	SET @RC = @@ROWCOUNT

	SET @Seq = @Seq + 1
END

IF OBJECT_ID('tempdb..#Cycles') IS NOT NULL
    DROP TABLE #Cycles

CREATE TABLE #Cycles
(
	ID INT IDENTITY(1,1) PRIMARY KEY,
	CycleID INT,
	NodeIDRoot INT,
	Seq INT,
	NGRecordId INT,
	SPRecordId INT,
	NodeName NVARCHAR(128),
	EdgeID INT
)

INSERT INTO #Cycles (NodeIDRoot, Seq, NGRecordId, SPRecordId, NodeName, EdgeID)
	SELECT NodeIDRoot, Seq, NGRecordId, SPRecordId, #Node.AccountName, EdgeID
	FROM #Graph
	INNER JOIN #Node ON #Graph.SPRecordId = #Node.RecordId
	WHERE IsCycle = 1
	ORDER BY #Graph.NodeIDRoot, #Graph.Seq

UPDATE #Cycles SET CycleID = ID

SET @RC = @@ROWCOUNT

WHILE @RC > 0 BEGIN
	INSERT INTO #Cycles (CycleID, NodeIDRoot, Seq, NGRecordId, SPRecordId, NodeName, EdgeID)
		SELECT DISTINCT #Cycles.CycleID, #Cycles.NodeIDRoot, #Graph.Seq, 
			#Graph.NGRecordId, #Graph.SPRecordId, #Node.AccountName, #Graph.EdgeID
		FROM #Cycles
		INNER JOIN #Graph ON #Cycles.NodeIDRoot = #Graph.NodeIDRoot
			AND #Cycles.Seq -1 = #Graph.Seq
			AND #Cycles.NGRecordId = #Graph.SPRecordId
		INNER JOIN #Node ON #Graph.SPRecordId = #Node.RecordId
		LEFT OUTER JOIN #Cycles ex ON #Cycles.CycleID = ex.CycleID
			AND ex.NodeIDRoot = #Cycles.NodeIDRoot
			AND ex.Seq = #Graph.Seq
			AND ex.NGRecordId = #Graph.NGRecordId
			AND ex.SPRecordId = #Graph.SPRecordId
			AND ex.EdgeID = #Graph.EdgeID
		WHERE ex.ID IS NULL
		ORDER BY #Cycles.NodeIDRoot, #Graph.Seq

	SET @RC = @@ROWCOUNT
END

DROP TABLE #Edge
DROP TABLE #Node
DROP TABLE #Graph

SELECT @sql = 
'SELECT @NewUserIdOUT = MIN(RecordId) FROM [' + @NGServicesDB + '].dbo.UserProfile;'
SET @Parms = N'@NewUserIdOUT BIGINT OUTPUT';
EXEC sp_executesql @sql, @Parms, @NewUserIdOUT=@NewUserId OUTPUT;

IF ISNULL(@NewUserId , 0) >= 0 SET @NewUserId = 0;

SELECT @Count = COUNT(*)
FROM #Cycles;

PRINT 'Working ' + CAST(@Count AS VARCHAR(25)) + ' cycles between new and old recordIds...'

DECLARE vendor_cursor CURSOR FOR 
	SELECT DISTINCT NGRecordId FROM #Cycles

OPEN vendor_cursor

FETCH NEXT FROM vendor_cursor INTO @OldUserId

WHILE (@@FETCH_STATUS = 0)
BEGIN
	SET @NewUserId = @NewUserId - 1;

	SELECT @sql = 
	'EXEC [' + @NGServicesDB + '].dbo.UPA_MigrateUserFromTempUser @OldUserId=@OldUserId, @NewUserId=@NewUserId'
	SET @Parms = N'@OldUserId BIGINT, @NewUserId BIGINT';
	EXEC sp_executesql @sql, @Parms, @OldUserId, @NewUserId
	
	SELECT @sql = 
	'EXEC [' + @NGReportingDB + '].dbo.UPA_ReportingMigrateUserFromTempUser @OldUserId=@OldUserId, @NewUserId=@NewUserId'
	SET @Parms = N'@OldUserId BIGINT, @NewUserId BIGINT';
	EXEC sp_executesql @sql, @Parms, @OldUserId, @NewUserId

	SELECT @sql = 
	'EXEC [' + @NGServicesDB + '].dbo.UPA_MigrateUserProfile @OldUserId=@OldUserId, @NewUserId=@NewUserId, @IsDeleted=0'
	SET @Parms = N'@OldUserId BIGINT, @NewUserId BIGINT, @IsDeleted BIT';
	EXEC sp_executesql @sql, @Parms, @OldUserId, @NewUserId, 0

	FETCH NEXT FROM vendor_cursor INTO @OldUserId
END 
CLOSE vendor_cursor;
DEALLOCATE vendor_cursor;

DROP TABLE #Cycles

--LL
--SELECT @sql = 
--'UPDATE [' + @NGServicesDB + '].dbo.UserProfile SET TempId = NULL'
--EXEC sp_executesql @sql

--Complete migration...
SET @More = 1;
SET @NewUserId = 0;
SET @OldUserId = 0;
SET @Count = 0;

TRUNCATE TABLE UPA_Mismatches

--LL
SELECT @sql = 
'INSERT INTO dbo.UPA_Mismatches ' +
'	SELECT NGUP.RecordId, SPUP.RecordID ' +
'	FROM [' + @NGServicesDB + '].dbo.UserProfile AS NGUP ' +
'	LEFT JOIN [' + @SPUserProfileDB + '].dbo.UserProfile_Full AS SPUP ON NGUP.AccountName = SPUP.NTName ' +
'	WHERE NGUP.RecordId != SPUP.RecordID AND SPUP.RecordId IS NOT NULL --AND NGUP.TempId IS NULL';
EXEC sp_executesql @sql

SELECT @Count = COUNT(*)
FROM dbo.UPA_Mismatches AS M1

PRINT 'Migrating ' + CAST(@Count AS VARCHAR(25)) + ' user profiles...'

WHILE @More = 1
BEGIN
	SET @More = 0;

	--TRUNCATE TABLE UPA_Mismatches

	----LL
	--SELECT @sql = 
	--'INSERT INTO dbo.UPA_Mismatches ' +
	--'	SELECT NGUP.RecordId, SPUP.RecordID ' +
	--'	FROM [' + @NGServicesDB + '].dbo.UserProfile AS NGUP ' +
	--'	LEFT JOIN [' + @SPUserProfileDB + '].dbo.UserProfile_Full AS SPUP ON NGUP.AccountName = SPUP.NTName ' +
	--'	WHERE NGUP.RecordId != SPUP.RecordID AND SPUP.RecordId IS NOT NULL AND NGUP.TempId IS NULL';
	--EXEC sp_executesql @sql

	--SELECT @Count = COUNT(*)
	--FROM dbo.UPA_Mismatches AS M1
	--LEFT JOIN dbo.UPA_Mismatches AS M2 ON M1.NewRecordId = M2.OldRecordId
	--WHERE M1.OldRecordId != ISNULL(M1.NewRecordId, 0)
	--	AND (M2.OldRecordId IS NULL OR M1.NewRecordId IS NULL);

	--PRINT 'Working ' + CAST(@Count AS VARCHAR(25)) + ' records this iteration...'

	DECLARE vendor_cursor CURSOR FOR 
		SELECT M1.OldRecordId, M1.NewRecordId
		FROM dbo.UPA_Mismatches AS M1
		LEFT JOIN dbo.UPA_Mismatches AS M2 ON M1.NewRecordId = M2.OldRecordId
		WHERE M1.OldRecordId != ISNULL(M1.NewRecordId, 0)
			AND (M2.OldRecordId IS NULL OR M1.NewRecordId IS NULL)

	OPEN vendor_cursor

	FETCH NEXT FROM vendor_cursor INTO @OldUserId, @NewUserId

	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		SET @More = 1;

		IF @NewUserId IS NULL
		BEGIN
			SELECT @sql = 
			'SELECT @NewUserIdOUT = MIN(RecordId) FROM [' + @NGServicesDB + '].dbo.UserProfile;'
			SET @Parms = N'@NewUserIdOUT BIGINT OUTPUT';
			EXEC sp_executesql @sql, @Parms, @NewUserIdOUT=@NewUserId OUTPUT;
			IF ISNULL(@NewUserId , 0) >= 0 SET @NewUserId = 0;
			SET @NewUserId = @NewUserId - 1;
		END

		SELECT @sql = 
		'EXEC [' + @NGServicesDB + '].dbo.UPA_MigrateUserFromTempUser @OldUserId=@OldUserId, @NewUserId=@NewUserId'
		SET @Parms = N'@OldUserId BIGINT, @NewUserId BIGINT';
		EXEC sp_executesql @sql, @Parms, @OldUserId, @NewUserId
		
		SELECT @sql = 
		'EXEC [' + @NGReportingDB + '].dbo.UPA_ReportingMigrateUserFromTempUser @OldUserId=@OldUserId, @NewUserId=@NewUserId'
		SET @Parms = N'@OldUserId BIGINT, @NewUserId BIGINT';
		EXEC sp_executesql @sql, @Parms, @OldUserId, @NewUserId

		SELECT @sql = 
		'EXEC [' + @NGServicesDB + '].dbo.UPA_MigrateUserProfile @OldUserId=@OldUserId, @NewUserId=@NewUserId, @IsDeleted=0'
		SET @Parms = N'@OldUserId BIGINT, @NewUserId BIGINT, @IsDeleted BIT';
		EXEC sp_executesql @sql, @Parms, @OldUserId, @NewUserId, 0

		SELECT @sql = 
		'DELETE FROM dbo.UPA_Mismatches WHERE OldRecordId=@OldUserId AND NewRecordId=@NewUserId;'
		SET @Parms = N'@OldUserId BIGINT, @NewUserId BIGINT';
		EXEC sp_executesql @sql, @Parms, @OldUserId, @NewUserId

		SET @Count = @Count - 1;

		IF (@Count % 1000) = 0 PRINT CAST(@Count AS VARCHAR(25)) + ' records remaining...'

		FETCH NEXT FROM vendor_cursor INTO @OldUserId, @NewUserId
	END 
	CLOSE vendor_cursor;
	DEALLOCATE vendor_cursor;
END

SELECT GETDATE();
