--Services 

if exists (select * from dbo.sysobjects where id = object_id(N'dbo.UPA_MigrateUserProfile') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure dbo.UPA_MigrateUserProfile
GO

CREATE PROCEDURE dbo.UPA_MigrateUserProfile
(
	@NewUserId bigint,	
	@OldUserId bigint,
	@IsDeleted BIT
)
AS
BEGIN
	DECLARE @OneBit BIT = 1;
	
	IF EXISTS(SELECT 1 FROM dbo.UserProfile WHERE RecordId=@NewUserId)
	BEGIN
		UPDATE dbo.UserProfile SET Deleted = @IsDeleted, TempId = NULL WHERE RecordId = @NewUserId;
	END
	ELSE
	BEGIN
		UPDATE dbo.UserProfile SET RecordId = @NewUserId, Deleted = @IsDeleted, TempId = NULL WHERE RecordId = @OldUserId;
	END

	--Mark old user profile deleted.
	IF @NewUserId <= 0
	BEGIN
		UPDATE dbo.UserProfile SET Deleted = @OneBit WHERE RecordId = @NewUserId;
	END
	ELSE
	BEGIN
		DELETE FROM dbo.UserProfile WHERE RecordId = @OldUserId;
	END
END
GO

if exists (select * from dbo.sysobjects where id = object_id(N'dbo.UPA_MigrateUserFromTempUser') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure dbo.UPA_MigrateUserFromTempUser
GO

CREATE PROCEDURE dbo.UPA_MigrateUserFromTempUser
(
	@NewUserId bigint,	
	@OldUserId bigint	
)
AS
BEGIN
	DECLARE @OneBit BIT = 1;

	--TRUNCATE TABLE dbo.MigrateUserQueue

	UPDATE dbo.ActivityEvent 
	SET UserId = @NewUserId WHERE UserId = @OldUserId

	UPDATE dbo.ActivityEventMeta 
	SET UserId = @NewUserId WHERE UserId = @OldUserId

	UPDATE dbo.ActivityEventFollowUp
	SET RecordId=@NewUserId
	FROM dbo.ActivityEventFollowUp AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.ActivityEventFollowUp AS T2
					WHERE T2.RecordId=@NewUserId 
					AND T2.HashCode=T1.HashCode);
	--DELETE FROM dbo.ActivityEventFollowUp WHERE RecordId=@OldUserId;

	UPDATE dbo.ActivityEventRecipient
	SET UserId=@NewUserId
	FROM dbo.ActivityEventRecipient AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.ActivityEventRecipient AS T2
					WHERE T2.UserId=@NewUserId 
					AND T2.EventId=T1.EventId);
	--DELETE FROM dbo.ActivityEventRecipient WHERE UserId=@OldUserId;

	UPDATE dbo.ActivityEventTargetedUser
	SET UserId=@NewUserId
	FROM dbo.ActivityEventTargetedUser AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.ActivityEventTargetedUser AS T2
					WHERE T2.UserId=@NewUserId 
					AND T2.EventId=T1.EventId);
	--DELETE FROM dbo.ActivityEventTargetedUser WHERE UserId=@OldUserId;

	UPDATE dbo.ActivityExternalEventMeta
	SET UserId = @NewUserId WHERE UserId = @OldUserId
	
	UPDATE dbo.BroadcastEvent
	SET UserId = @NewUserId WHERE UserId = @OldUserId
		
	UPDATE dbo.Colleague
	SET OwnerId=@NewUserId
	FROM dbo.Colleague AS T1
	WHERE T1.OwnerId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.Colleague AS T2
					WHERE T2.OwnerId=@NewUserId 
					AND T2.ColleagueId=T1.ColleagueId);

	UPDATE dbo.Colleague
	SET ColleagueId=@NewUserId
	FROM dbo.Colleague AS T1
	WHERE T1.ColleagueId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.Colleague AS T2
					WHERE T2.ColleagueId=@NewUserId 
					AND T2.OwnerId=T1.OwnerId);

	UPDATE dbo.ActivityEventTag 
	SET UserId = @NewUserId WHERE UserId = @OldUserId
	
	UPDATE dbo.EventNotification
	SET ActingUserId = @NewUserId WHERE ActingUserId = @OldUserId

	UPDATE dbo.EventNotification
	SET PublishingUserId = @NewUserId WHERE PublishingUserId = @OldUserId

	UPDATE dbo.EventNotification
	SET UserId = @NewUserId WHERE UserId = @OldUserId

	UPDATE dbo.EventNotificationSent
	SET UserId = @NewUserId WHERE UserId = @OldUserId

	UPDATE dbo.SocialGroupPromotion
	SET UserId = @NewUserId WHERE UserId = @OldUserId

	UPDATE dbo.AudienceMember
	SET RecordId=@NewUserId
	FROM dbo.AudienceMember AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.AudienceMember AS T2
					WHERE T2.RecordId=@NewUserId 
					AND T2.AudienceId=T1.AudienceId);
	--DELETE FROM dbo.AudienceMember WHERE RecordId=@OldUserId;

	UPDATE dbo.ExternalUsersToUserProfileLookup
	SET RecordId = @NewUserId WHERE RecordId = @OldUserId
		
	UPDATE dbo.IgnoredSocialGroup
	SET RecordId=@NewUserId
	FROM dbo.IgnoredSocialGroup AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.IgnoredSocialGroup AS T2
					WHERE T2.RecordId=@NewUserId 
					AND T2.GroupId=T1.GroupId);
	--DELETE FROM dbo.IgnoredSocialGroup WHERE RecordId=@OldUserId;

	UPDATE dbo.LegalHoldUser
	SET UserId = @NewUserId WHERE UserId = @OldUserId
	
	UPDATE dbo.ProfileEventKey
	SET UserId = @NewUserId WHERE UserId = @OldUserId

--SocialGroupMembership------------------------------------------------------------------------------

	--This one moves rows for the old recordId to the new recordId where there is no row with the
	--new recordId for this group already there.  If the row gets moved, then all of the data goes with
	--it.  SO no need to worry about OwnerId in this case.
	UPDATE dbo.SocialGroupMembership
	SET RecordId=@NewUserId
	FROM dbo.SocialGroupMembership AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.SocialGroupMembership AS T2
					WHERE T2.RecordId=@NewUserId 
					AND T2.GroupId=T1.GroupId);

	--This one will update the rows that were not able to be migrated due to a duplicate row.  If the user
	--has come in and followed the community or sphere again, then there will be a new row for the user.
	--But re-following won't grab the IsOwner part of the row.  So we need to update that data from te old rows.
	--This one will grab all of the other important data about the group membership row if a user re-follows.
	UPDATE dbo.SocialGroupMembership
		SET IsOwner = S.IsOwner, [Description] = S.[Description], JoinDate = S.JoinDate, 
			UserAction = S.UserAction, SecurityGroupMember = S.SecurityGroupMember, IsCurator = S.IsCurator, IsMvp = S.IsMvp
	FROM dbo.SocialGroupMembership AS T
	INNER JOIN (SELECT GroupId, RecordId, IsOwner, [Description], JoinDate, UserAction, SecurityGroupMember, IsCurator, IsMvp
					FROM dbo.SocialGroupMembership
					WHERE RecordId=@OldUserId) AS S ON S.GroupId = T.GroupId
	WHERE T.RecordId=@NewUserId;

------------------------------------------------------------------------------------------

	UPDATE dbo.SocialGroupSubscriber
	SET RecordId=@NewUserId
	FROM dbo.SocialGroupSubscriber AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.SocialGroupSubscriber AS T2
					WHERE T2.RecordId=@NewUserId 
					AND T2.GroupId=T1.GroupId 
					AND ISNULL(T2.EventType, '')=ISNULL(T1.EventType,''));
	--DELETE FROM dbo.SocialGroupSubscriber WHERE RecordId=@OldUserId;

	UPDATE dbo.TermsAndConditionsAccepted
	SET UserId=@NewUserId
	FROM dbo.TermsAndConditionsAccepted AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.TermsAndConditionsAccepted AS T2
					WHERE T2.UserId=@NewUserId 
					AND T2.TermsAndConditionsID=T1.TermsAndConditionsID);
	--DELETE FROM dbo.TermsAndConditionsAccepted WHERE UserId=@OldUserId;

	UPDATE dbo.TutorialStatus
	SET UserId=@NewUserId
	FROM dbo.TutorialStatus AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.TutorialStatus AS T2
					WHERE T2.UserId=@NewUserId);
	--DELETE FROM dbo.TutorialStatus WHERE UserId=@OldUserId;

	UPDATE dbo.Idea SET UserId = @NewUserId WHERE UserId = @OldUserId
	
	UPDATE dbo.IdeaVote SET VoterId = @NewUserId WHERE VoterId = @OldUserId
	UPDATE dbo.IdeaVote SET IdeaOwnerId = @NewUserId WHERE IdeaOwnerId = @OldUserId

	UPDATE dbo.ActivityEventMuted
	SET RecordId=@NewUserId
	FROM dbo.ActivityEventMuted AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.ActivityEventMuted AS T2
					WHERE T2.RecordId=@NewUserId 
					AND T2.HashCode=T1.HashCode);
	--DELETE FROM dbo.ActivityEventMuted WHERE RecordId=@OldUserId;

	UPDATE dbo.DashboardTile
	SET RecordId = @NewUserId WHERE RecordId = @OldUserId
		
	UPDATE dbo.TileConfig
	SET RecordId = @NewUserId WHERE RecordId = @OldUserId

	--4.5 table
	--UPDATE dbo.TileDigest
	--SET RecordId=@NewUserId
	--FROM dbo.TileDigest AS T1
	--WHERE T1.RecordId=@OldUserId
	--AND NOT EXISTS(SELECT 1 FROM dbo.TileDigest AS T2
	--				WHERE T2.RecordId=@NewUserId
	--				AND T2.TileId=T1.TileId);
	--DELETE FROM dbo.TileDigest WHERE RecordId=@OldUserId;

	UPDATE dbo.TileSetDeletedCache
	SET RecordId=@NewUserId
	FROM dbo.TileSetDeletedCache AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.TileSetDeletedCache AS T2
					WHERE T2.RecordId=@NewUserId
					AND T2.TileSetDashboardId=T1.TileSetDashboardId);
	--DELETE FROM dbo.TileSetDeletedCache WHERE RecordId=@OldUserId;

	UPDATE dbo.Tip
	SET UserId=@NewUserId
	FROM dbo.Tip AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.Tip AS T2
					WHERE T2.UserId=@NewUserId);
	--DELETE FROM dbo.Tip WHERE UserId=@OldUserId;

	UPDATE dbo.DigestNotification
	SET RecordId = @NewUserId 
	WHERE DigestNotification.RecordId = @OldUserId AND
		NOT EXISTS(SELECT 1 FROM dbo.DigestNotification WHERE RecordId=@NewUserId);

	UPDATE dbo.DigestSettingsDetails
	SET RecordId=@NewUserId
	FROM dbo.DigestSettingsDetails AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.DigestSettingsDetails AS T2
					WHERE T2.RecordId=@NewUserId
					AND ISNULL(T2.ActivityTypeId,0)=ISNULL(T1.ActivityTypeId,0)
					AND ISNULL(T2.ColleagueId,0)=ISNULL(T1.ColleagueId,0)
					AND ISNULL(T2.GroupId,'00000000-0000-0000-0000-000000000000')=ISNULL(T1.GroupId,'00000000-0000-0000-0000-000000000000'));
	--DELETE FROM dbo.DigestSettingsDetails WHERE RecordId=@OldUserId;

	UPDATE dbo.DigestSettingsDetails
	SET ColleagueId=@NewUserId
	FROM dbo.DigestSettingsDetails AS T1
	WHERE T1.ColleagueId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.DigestSettingsDetails AS T2
					WHERE T2.ColleagueId=@NewUserId
					AND ISNULL(T2.ActivityTypeId,0)=ISNULL(T1.ActivityTypeId,0)
					AND ISNULL(T2.RecordId,0)=ISNULL(T1.RecordId,0)
					AND ISNULL(T2.GroupId,'00000000-0000-0000-0000-000000000000')=ISNULL(T1.GroupId,'00000000-0000-0000-0000-000000000000'));
	--DELETE FROM dbo.DigestSettingsDetails WHERE ColleagueId=@OldUserId;

	UPDATE dbo.NotificationSetting
	SET RecordId=@NewUserId
	FROM dbo.NotificationSetting AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.NotificationSetting AS T2
					WHERE T2.RecordId=@NewUserId
					AND T2.TypeInternalName=T1.TypeInternalName);
	--DELETE FROM dbo.NotificationSetting WHERE RecordId=@OldUserId;

	UPDATE dbo.UrlKey
	SET UserId = @NewUserId WHERE UserId = @OldUserId

	UPDATE dbo.RecommendationsJobLastRun
	SET LastColleagueRecordId = @NewUserId WHERE LastColleagueRecordId = @OldUserId

	UPDATE dbo.RecommendationsJobLastRun
	SET LastKeywordRecordId = @NewUserId WHERE LastKeywordRecordId = @OldUserId

	UPDATE dbo.UserSpecialistTag
	SET UserId = @NewUserId 
	WHERE UserSpecialistTag.UserId = @OldUserId AND
		NOT EXISTS(SELECT 1 FROM dbo.UserSpecialistTag WHERE UserId=@NewUserId AND Tag=UserSpecialistTag.Tag)

	UPDATE dbo.UserSubscribedTag
	SET UserId = @NewUserId 
	WHERE UserSubscribedTag.UserId = @OldUserId AND
		NOT EXISTS(SELECT 1 FROM dbo.UserSubscribedTag WHERE UserId=@NewUserId AND Tag=UserSubscribedTag.Tag)

	UPDATE dbo.UserTag
	SET UserId = @NewUserId 
	WHERE UserTag.UserId = @OldUserId AND
		NOT EXISTS(SELECT 1 FROM dbo.UserTag WHERE UserId=@NewUserId AND Tag=UserTag.Tag)

	UPDATE dbo.FollowedDocument
	SET AuthorId=@NewUserId
	FROM dbo.FollowedDocument AS T1
	WHERE T1.AuthorId=@OldUserId

	UPDATE dbo.FollowedDocument
	SET ModifiedByAuthorId=@NewUserId
	FROM dbo.FollowedDocument AS T1
	WHERE T1.ModifiedByAuthorId=@OldUserId

	UPDATE dbo.FollowedDocument
	SET UserId=@NewUserId
	FROM dbo.FollowedDocument AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.FollowedDocument AS T2
					WHERE T2.UserId=@NewUserId 
					AND T2.FarmId=T1.FarmId 
					AND T2.SiteId=T1.SiteId
					AND T2.WebId=T1.WebId
					AND T2.ListId=T1.ListId
					AND T2.ListItemId=T1.ListItemId
					);
	--DELETE FROM dbo.FollowedDocument WHERE UserId=@OldUserId;
	
	UPDATE dbo.ColleagueSuggestion
	SET SuggestedColleagueId=@NewUserId
	FROM dbo.ColleagueSuggestion AS T1
	WHERE T1.SuggestedColleagueId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.ColleagueSuggestion AS T2
					WHERE T2.SuggestedColleagueId=@NewUserId 
					AND T2.UserId=T1.UserId);
					
	UPDATE dbo.ColleagueSuggestion
	SET UserId=@NewUserId
	FROM dbo.ColleagueSuggestion AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.ColleagueSuggestion AS T2
					WHERE T2.UserId=@NewUserId 
					AND T2.SuggestedColleagueId=T1.SuggestedColleagueId);
	--DELETE FROM dbo.ColleagueSuggestion WHERE UserId=@OldUserId;

	UPDATE dbo.Devices
	SET UserId=@NewUserId
	FROM dbo.Devices AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.Devices AS T2
					WHERE T2.UserId=@NewUserId );
	--DELETE FROM dbo.Devices WHERE UserId=@OldUserId;

	UPDATE dbo.GlobalCuratorPrincipal
	SET RecordId=@NewUserId
	FROM dbo.GlobalCuratorPrincipal AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.GlobalCuratorPrincipal AS T2
					WHERE T2.RecordId=@NewUserId );
	--DELETE FROM dbo.GlobalCuratorPrincipal WHERE RecordId=@OldUserId;
	
	UPDATE dbo.Idea
	SET UserId=@NewUserId
	FROM dbo.Idea AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.Idea AS T2
					WHERE T2.UserId=@NewUserId );
	--DELETE FROM dbo.Idea WHERE UserId=@OldUserId;
	
	UPDATE dbo.MonitoredAudienceMembership
	SET RecordId=@NewUserId
	FROM dbo.MonitoredAudienceMembership AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.MonitoredAudienceMembership AS T2
					WHERE T2.RecordId=@NewUserId );
	--DELETE FROM dbo.MonitoredAudienceMembership WHERE RecordId=@OldUserId;

	--4.5 table
	--UPDATE dbo.SocialGroupDigest
	--SET RecordId=@NewUserId
	--FROM dbo.SocialGroupDigest AS T1
	--WHERE T1.RecordId=@OldUserId
	--AND NOT EXISTS(SELECT 1 FROM dbo.SocialGroupDigest AS T2
	--				WHERE T2.RecordId=@NewUserId );
	--DELETE FROM dbo.SocialGroupDigest WHERE RecordId=@OldUserId;

	UPDATE dbo.RecommendationsColleague
	SET ColleagueSuggestionId=@NewUserId
	FROM dbo.RecommendationsColleague AS T1
	WHERE T1.ColleagueSuggestionId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.RecommendationsColleague AS T2
					WHERE T2.ColleagueSuggestionId=@NewUserId
					AND T2.OwnerId=T1.OwnerId);

	UPDATE dbo.RecommendationsColleague
	SET OwnerId=@NewUserId
	FROM dbo.RecommendationsColleague AS T1
	WHERE T1.OwnerId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.RecommendationsColleague AS T2
					WHERE T2.OwnerId=@NewUserId
					AND T2.ColleagueSuggestionId=T1.ColleagueSuggestionId);
	--DELETE FROM dbo.RecommendationsColleague WHERE OwnerId=@OldUserId;

	UPDATE dbo.RecommendationsCommunity
	SET OwnerId=@NewUserId
	FROM dbo.RecommendationsCommunity AS T1
	WHERE T1.OwnerId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.RecommendationsCommunity AS T2
					WHERE T2.OwnerId=@NewUserId
					AND T2.CommunitySuggestionId=T1.CommunitySuggestionId);
	--DELETE FROM dbo.RecommendationsCommunity WHERE OwnerId=@OldUserId;

	UPDATE dbo.RecommendationsKeyword
	SET OwnerId=@NewUserId
	FROM dbo.RecommendationsKeyword AS T1
	WHERE T1.OwnerId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.RecommendationsKeyword AS T2
					WHERE T2.OwnerId=@NewUserId
					AND T2.Keyword=T1.Keyword);
	--DELETE FROM dbo.RecommendationsKeyword WHERE OwnerId=@OldUserId;
END
GO
